(function () {
    'use strict';

    const hour = 17;
    const p1 = [
        [`11 ${hour}:`, ["01", "10"]],
        [`21 ${hour}:`, ['11', '20']],
        [`01 ${hour}:`, ['21', 0]],
        [`05 00:`, ['01', 0]]
    ];
    // const p2 = [
    //     [`11 ${hour}:`, ["01", "10"]],
    //     [`21 ${hour}:`, ['11', '20']],
    //     [`05 00:`, ['01', 0]]
    // ];
    const TABLE = {
        WFS: {
            name: "WFS",
            uri: "https://seller.walmart.com/aurora/v1/wfs/reports/",
            params: p1
        },
        PAYMENT: {
            name: "放款表",
            uri: "https://seller.walmart.com/aurora/v1/",
            params: p1
        },
        GQL: {
            name: "营销表",
            uri: "https://seller.walmart.com/aurora/v2/marketing-self-serve/gql",
            params: p1
        },
        ORDER: {
            name: "订单表",
            uri: "https://seller.walmart.com/aurora/v1/reports/",
            params: p1
        },
        ADVERT: {
            name: "广告表",
            uri: "https://advertising.walmart.com/sp/api/",
            params: p1
        }
    };

    function getDefaultExportFromCjs (x) {
    	return x && x.__esModule && Object.prototype.hasOwnProperty.call(x, 'default') ? x['default'] : x;
    }

    var dayjs_min$1 = {exports: {}};

    var dayjs_min = dayjs_min$1.exports;

    var hasRequiredDayjs_min;

    function requireDayjs_min () {
    	if (hasRequiredDayjs_min) return dayjs_min$1.exports;
    	hasRequiredDayjs_min = 1;
    	(function (module, exports$1) {
    		!function(t,e){module.exports=e();}(dayjs_min,(function(){var t=1e3,e=6e4,n=36e5,r="millisecond",i="second",s="minute",u="hour",a="day",o="week",c="month",f="quarter",h="year",d="date",l="Invalid Date",$=/^(\d{4})[-/]?(\d{1,2})?[-/]?(\d{0,2})[Tt\s]*(\d{1,2})?:?(\d{1,2})?:?(\d{1,2})?[.:]?(\d+)?$/,y=/\[([^\]]+)]|Y{1,4}|M{1,4}|D{1,2}|d{1,4}|H{1,2}|h{1,2}|a|A|m{1,2}|s{1,2}|Z{1,2}|SSS/g,M={name:"en",weekdays:"Sunday_Monday_Tuesday_Wednesday_Thursday_Friday_Saturday".split("_"),months:"January_February_March_April_May_June_July_August_September_October_November_December".split("_"),ordinal:function(t){var e=["th","st","nd","rd"],n=t%100;return "["+t+(e[(n-20)%10]||e[n]||e[0])+"]"}},m=function(t,e,n){var r=String(t);return !r||r.length>=e?t:""+Array(e+1-r.length).join(n)+t},v={s:m,z:function(t){var e=-t.utcOffset(),n=Math.abs(e),r=Math.floor(n/60),i=n%60;return (e<=0?"+":"-")+m(r,2,"0")+":"+m(i,2,"0")},m:function t(e,n){if(e.date()<n.date())return -t(n,e);var r=12*(n.year()-e.year())+(n.month()-e.month()),i=e.clone().add(r,c),s=n-i<0,u=e.clone().add(r+(s?-1:1),c);return +(-(r+(n-i)/(s?i-u:u-i))||0)},a:function(t){return t<0?Math.ceil(t)||0:Math.floor(t)},p:function(t){return {M:c,y:h,w:o,d:a,D:d,h:u,m:s,s:i,ms:r,Q:f}[t]||String(t||"").toLowerCase().replace(/s$/,"")},u:function(t){return void 0===t}},g="en",D={};D[g]=M;var p="$isDayjsObject",S=function(t){return t instanceof _||!(!t||!t[p])},w=function t(e,n,r){var i;if(!e)return g;if("string"==typeof e){var s=e.toLowerCase();D[s]&&(i=s),n&&(D[s]=n,i=s);var u=e.split("-");if(!i&&u.length>1)return t(u[0])}else {var a=e.name;D[a]=e,i=a;}return !r&&i&&(g=i),i||!r&&g},O=function(t,e){if(S(t))return t.clone();var n="object"==typeof e?e:{};return n.date=t,n.args=arguments,new _(n)},b=v;b.l=w,b.i=S,b.w=function(t,e){return O(t,{locale:e.$L,utc:e.$u,x:e.$x,$offset:e.$offset})};var _=function(){function M(t){this.$L=w(t.locale,null,true),this.parse(t),this.$x=this.$x||t.x||{},this[p]=true;}var m=M.prototype;return m.parse=function(t){this.$d=function(t){var e=t.date,n=t.utc;if(null===e)return new Date(NaN);if(b.u(e))return new Date;if(e instanceof Date)return new Date(e);if("string"==typeof e&&!/Z$/i.test(e)){var r=e.match($);if(r){var i=r[2]-1||0,s=(r[7]||"0").substring(0,3);return n?new Date(Date.UTC(r[1],i,r[3]||1,r[4]||0,r[5]||0,r[6]||0,s)):new Date(r[1],i,r[3]||1,r[4]||0,r[5]||0,r[6]||0,s)}}return new Date(e)}(t),this.init();},m.init=function(){var t=this.$d;this.$y=t.getFullYear(),this.$M=t.getMonth(),this.$D=t.getDate(),this.$W=t.getDay(),this.$H=t.getHours(),this.$m=t.getMinutes(),this.$s=t.getSeconds(),this.$ms=t.getMilliseconds();},m.$utils=function(){return b},m.isValid=function(){return !(this.$d.toString()===l)},m.isSame=function(t,e){var n=O(t);return this.startOf(e)<=n&&n<=this.endOf(e)},m.isAfter=function(t,e){return O(t)<this.startOf(e)},m.isBefore=function(t,e){return this.endOf(e)<O(t)},m.$g=function(t,e,n){return b.u(t)?this[e]:this.set(n,t)},m.unix=function(){return Math.floor(this.valueOf()/1e3)},m.valueOf=function(){return this.$d.getTime()},m.startOf=function(t,e){var n=this,r=!!b.u(e)||e,f=b.p(t),l=function(t,e){var i=b.w(n.$u?Date.UTC(n.$y,e,t):new Date(n.$y,e,t),n);return r?i:i.endOf(a)},$=function(t,e){return b.w(n.toDate()[t].apply(n.toDate("s"),(r?[0,0,0,0]:[23,59,59,999]).slice(e)),n)},y=this.$W,M=this.$M,m=this.$D,v="set"+(this.$u?"UTC":"");switch(f){case h:return r?l(1,0):l(31,11);case c:return r?l(1,M):l(0,M+1);case o:var g=this.$locale().weekStart||0,D=(y<g?y+7:y)-g;return l(r?m-D:m+(6-D),M);case a:case d:return $(v+"Hours",0);case u:return $(v+"Minutes",1);case s:return $(v+"Seconds",2);case i:return $(v+"Milliseconds",3);default:return this.clone()}},m.endOf=function(t){return this.startOf(t,false)},m.$set=function(t,e){var n,o=b.p(t),f="set"+(this.$u?"UTC":""),l=(n={},n[a]=f+"Date",n[d]=f+"Date",n[c]=f+"Month",n[h]=f+"FullYear",n[u]=f+"Hours",n[s]=f+"Minutes",n[i]=f+"Seconds",n[r]=f+"Milliseconds",n)[o],$=o===a?this.$D+(e-this.$W):e;if(o===c||o===h){var y=this.clone().set(d,1);y.$d[l]($),y.init(),this.$d=y.set(d,Math.min(this.$D,y.daysInMonth())).$d;}else l&&this.$d[l]($);return this.init(),this},m.set=function(t,e){return this.clone().$set(t,e)},m.get=function(t){return this[b.p(t)]()},m.add=function(r,f){var d,l=this;r=Number(r);var $=b.p(f),y=function(t){var e=O(l);return b.w(e.date(e.date()+Math.round(t*r)),l)};if($===c)return this.set(c,this.$M+r);if($===h)return this.set(h,this.$y+r);if($===a)return y(1);if($===o)return y(7);var M=(d={},d[s]=e,d[u]=n,d[i]=t,d)[$]||1,m=this.$d.getTime()+r*M;return b.w(m,this)},m.subtract=function(t,e){return this.add(-1*t,e)},m.format=function(t){var e=this,n=this.$locale();if(!this.isValid())return n.invalidDate||l;var r=t||"YYYY-MM-DDTHH:mm:ssZ",i=b.z(this),s=this.$H,u=this.$m,a=this.$M,o=n.weekdays,c=n.months,f=n.meridiem,h=function(t,n,i,s){return t&&(t[n]||t(e,r))||i[n].slice(0,s)},d=function(t){return b.s(s%12||12,t,"0")},$=f||function(t,e,n){var r=t<12?"AM":"PM";return n?r.toLowerCase():r};return r.replace(y,(function(t,r){return r||function(t){switch(t){case "YY":return String(e.$y).slice(-2);case "YYYY":return b.s(e.$y,4,"0");case "M":return a+1;case "MM":return b.s(a+1,2,"0");case "MMM":return h(n.monthsShort,a,c,3);case "MMMM":return h(c,a);case "D":return e.$D;case "DD":return b.s(e.$D,2,"0");case "d":return String(e.$W);case "dd":return h(n.weekdaysMin,e.$W,o,2);case "ddd":return h(n.weekdaysShort,e.$W,o,3);case "dddd":return o[e.$W];case "H":return String(s);case "HH":return b.s(s,2,"0");case "h":return d(1);case "hh":return d(2);case "a":return $(s,u,true);case "A":return $(s,u,false);case "m":return String(u);case "mm":return b.s(u,2,"0");case "s":return String(e.$s);case "ss":return b.s(e.$s,2,"0");case "SSS":return b.s(e.$ms,3,"0");case "Z":return i}return null}(t)||i.replace(":","")}))},m.utcOffset=function(){return 15*-Math.round(this.$d.getTimezoneOffset()/15)},m.diff=function(r,d,l){var $,y=this,M=b.p(d),m=O(r),v=(m.utcOffset()-this.utcOffset())*e,g=this-m,D=function(){return b.m(y,m)};switch(M){case h:$=D()/12;break;case c:$=D();break;case f:$=D()/3;break;case o:$=(g-v)/6048e5;break;case a:$=(g-v)/864e5;break;case u:$=g/n;break;case s:$=g/e;break;case i:$=g/t;break;default:$=g;}return l?$:b.a($)},m.daysInMonth=function(){return this.endOf(c).$D},m.$locale=function(){return D[this.$L]},m.locale=function(t,e){if(!t)return this.$L;var n=this.clone(),r=w(t,e,true);return r&&(n.$L=r),n},m.clone=function(){return b.w(this.$d,this)},m.toDate=function(){return new Date(this.valueOf())},m.toJSON=function(){return this.isValid()?this.toISOString():null},m.toISOString=function(){return this.$d.toISOString()},m.toString=function(){return this.$d.toUTCString()},M}(),k=_.prototype;return O.prototype=k,[["$ms",r],["$s",i],["$m",s],["$H",u],["$W",a],["$M",c],["$y",h],["$D",d]].forEach((function(t){k[t[1]]=function(e){return this.$g(e,t[0],t[1])};})),O.extend=function(t,e){return t.$i||(t(e,_,O),t.$i=true),O},O.locale=w,O.isDayjs=S,O.unix=function(t){return O(1e3*t)},O.en=D[g],O.Ls=D,O.p={},O})); 
    	} (dayjs_min$1));
    	return dayjs_min$1.exports;
    }

    var dayjs_minExports = requireDayjs_min();
    var dayjs = /*@__PURE__*/getDefaultExportFromCjs(dayjs_minExports);

    var utc$2 = {exports: {}};

    var utc$1 = utc$2.exports;

    var hasRequiredUtc;

    function requireUtc () {
    	if (hasRequiredUtc) return utc$2.exports;
    	hasRequiredUtc = 1;
    	(function (module, exports$1) {
    		!function(t,i){module.exports=i();}(utc$1,(function(){var t="minute",i=/[+-]\d\d(?::?\d\d)?/g,e=/([+-]|\d\d)/g;return function(s,f,n){var u=f.prototype;n.utc=function(t){var i={date:t,utc:true,args:arguments};return new f(i)},u.utc=function(i){var e=n(this.toDate(),{locale:this.$L,utc:true});return i?e.add(this.utcOffset(),t):e},u.local=function(){return n(this.toDate(),{locale:this.$L,utc:false})};var r=u.parse;u.parse=function(t){t.utc&&(this.$u=true),this.$utils().u(t.$offset)||(this.$offset=t.$offset),r.call(this,t);};var o=u.init;u.init=function(){if(this.$u){var t=this.$d;this.$y=t.getUTCFullYear(),this.$M=t.getUTCMonth(),this.$D=t.getUTCDate(),this.$W=t.getUTCDay(),this.$H=t.getUTCHours(),this.$m=t.getUTCMinutes(),this.$s=t.getUTCSeconds(),this.$ms=t.getUTCMilliseconds();}else o.call(this);};var a=u.utcOffset;u.utcOffset=function(s,f){var n=this.$utils().u;if(n(s))return this.$u?0:n(this.$offset)?a.call(this):this.$offset;if("string"==typeof s&&(s=function(t){ void 0===t&&(t="");var s=t.match(i);if(!s)return null;var f=(""+s[0]).match(e)||["-",0,0],n=f[0],u=60*+f[1]+ +f[2];return 0===u?0:"+"===n?u:-u}(s),null===s))return this;var u=Math.abs(s)<=16?60*s:s;if(0===u)return this.utc(f);var r=this.clone();if(f)return r.$offset=u,r.$u=false,r;var o=this.$u?this.toDate().getTimezoneOffset():-1*this.utcOffset();return (r=this.local().add(u+o,t)).$offset=u,r.$x.$localOffset=o,r};var h=u.format;u.format=function(t){var i=t||(this.$u?"YYYY-MM-DDTHH:mm:ss[Z]":"");return h.call(this,i)},u.valueOf=function(){var t=this.$utils().u(this.$offset)?0:this.$offset+(this.$x.$localOffset||this.$d.getTimezoneOffset());return this.$d.valueOf()-6e4*t},u.isUTC=function(){return !!this.$u},u.toISOString=function(){return this.toDate().toISOString()},u.toString=function(){return this.toDate().toUTCString()};var l=u.toDate;u.toDate=function(t){return "s"===t&&this.$offset?n(this.format("YYYY-MM-DD HH:mm:ss:SSS")).toDate():l.call(this)};var c=u.diff;u.diff=function(t,i,e){if(t&&this.$u===t.$u)return c.call(this,t,i,e);var s=this.local(),f=n(t).local();return c.call(s,f,i,e)};}})); 
    	} (utc$2));
    	return utc$2.exports;
    }

    var utcExports = requireUtc();
    var utc = /*@__PURE__*/getDefaultExportFromCjs(utcExports);

    var timezone$2 = {exports: {}};

    var timezone$1 = timezone$2.exports;

    var hasRequiredTimezone;

    function requireTimezone () {
    	if (hasRequiredTimezone) return timezone$2.exports;
    	hasRequiredTimezone = 1;
    	(function (module, exports$1) {
    		!function(t,e){module.exports=e();}(timezone$1,(function(){var t={year:0,month:1,day:2,hour:3,minute:4,second:5},e={};return function(n,i,o){var r,a=function(t,n,i){ void 0===i&&(i={});var o=new Date(t),r=function(t,n){ void 0===n&&(n={});var i=n.timeZoneName||"short",o=t+"|"+i,r=e[o];return r||(r=new Intl.DateTimeFormat("en-US",{hour12:false,timeZone:t,year:"numeric",month:"2-digit",day:"2-digit",hour:"2-digit",minute:"2-digit",second:"2-digit",timeZoneName:i}),e[o]=r),r}(n,i);return r.formatToParts(o)},u=function(e,n){for(var i=a(e,n),r=[],u=0;u<i.length;u+=1){var f=i[u],s=f.type,m=f.value,c=t[s];c>=0&&(r[c]=parseInt(m,10));}var d=r[3],l=24===d?0:d,h=r[0]+"-"+r[1]+"-"+r[2]+" "+l+":"+r[4]+":"+r[5]+":000",v=+e;return (o.utc(h).valueOf()-(v-=v%1e3))/6e4},f=i.prototype;f.tz=function(t,e){ void 0===t&&(t=r);var n,i=this.utcOffset(),a=this.toDate(),u=a.toLocaleString("en-US",{timeZone:t}),f=Math.round((a-new Date(u))/1e3/60),s=15*-Math.round(a.getTimezoneOffset()/15)-f;if(!Number(s))n=this.utcOffset(0,e);else if(n=o(u,{locale:this.$L}).$set("millisecond",this.$ms).utcOffset(s,true),e){var m=n.utcOffset();n=n.add(i-m,"minute");}return n.$x.$timezone=t,n},f.offsetName=function(t){var e=this.$x.$timezone||o.tz.guess(),n=a(this.valueOf(),e,{timeZoneName:t}).find((function(t){return "timezonename"===t.type.toLowerCase()}));return n&&n.value};var s=f.startOf;f.startOf=function(t,e){if(!this.$x||!this.$x.$timezone)return s.call(this,t,e);var n=o(this.format("YYYY-MM-DD HH:mm:ss:SSS"),{locale:this.$L});return s.call(n,t,e).tz(this.$x.$timezone,true)},o.tz=function(t,e,n){var i=n&&e,a=n||e||r,f=u(+o(),a);if("string"!=typeof t)return o(t).tz(a);var s=function(t,e,n){var i=t-60*e*1e3,o=u(i,n);if(e===o)return [i,e];var r=u(i-=60*(o-e)*1e3,n);return o===r?[i,o]:[t-60*Math.min(o,r)*1e3,Math.max(o,r)]}(o.utc(t,i).valueOf(),f,a),m=s[0],c=s[1],d=o(m).utcOffset(c);return d.$x.$timezone=a,d},o.tz.guess=function(){return Intl.DateTimeFormat().resolvedOptions().timeZone},o.tz.setDefault=function(t){r=t;};}})); 
    	} (timezone$2));
    	return timezone$2.exports;
    }

    var timezoneExports = requireTimezone();
    var timezone = /*@__PURE__*/getDefaultExportFromCjs(timezoneExports);

    var isSameOrAfter$2 = {exports: {}};

    var isSameOrAfter$1 = isSameOrAfter$2.exports;

    var hasRequiredIsSameOrAfter;

    function requireIsSameOrAfter () {
    	if (hasRequiredIsSameOrAfter) return isSameOrAfter$2.exports;
    	hasRequiredIsSameOrAfter = 1;
    	(function (module, exports$1) {
    		!function(e,t){module.exports=t();}(isSameOrAfter$1,(function(){return function(e,t){t.prototype.isSameOrAfter=function(e,t){return this.isSame(e,t)||this.isAfter(e,t)};}})); 
    	} (isSameOrAfter$2));
    	return isSameOrAfter$2.exports;
    }

    var isSameOrAfterExports = requireIsSameOrAfter();
    var isSameOrAfter = /*@__PURE__*/getDefaultExportFromCjs(isSameOrAfterExports);

    var isSameOrBefore$2 = {exports: {}};

    var isSameOrBefore$1 = isSameOrBefore$2.exports;

    var hasRequiredIsSameOrBefore;

    function requireIsSameOrBefore () {
    	if (hasRequiredIsSameOrBefore) return isSameOrBefore$2.exports;
    	hasRequiredIsSameOrBefore = 1;
    	(function (module, exports$1) {
    		!function(e,i){module.exports=i();}(isSameOrBefore$1,(function(){return function(e,i){i.prototype.isSameOrBefore=function(e,i){return this.isSame(e,i)||this.isBefore(e,i)};}})); 
    	} (isSameOrBefore$2));
    	return isSameOrBefore$2.exports;
    }

    var isSameOrBeforeExports = requireIsSameOrBefore();
    var isSameOrBefore = /*@__PURE__*/getDefaultExportFromCjs(isSameOrBeforeExports);

    dayjs.extend(utc);
    dayjs.extend(timezone);
    dayjs.extend(isSameOrAfter);
    dayjs.extend(isSameOrBefore);

    const CST = "Asia/Shanghai";
    const PT = "America/Los_Angeles";
    class Plan {
        constructor(dt, params) {
            this.dt = dayjs.tz(dt ?? new Date(), CST);
            this.setHandler();
            this.table = new Proxy({}, this.handler);
            this.params = [];
            params?.forEach(param => this._addParam(...param));
        }
        setHandler() {
            this.handler = {
                dt: this.dt,
                order: [],  // 逆序
                get(obj, prop) {
                    if (prop in obj) return obj[prop];
                    const idx = this.order.find(x => prop - x >= 0);
                    return obj[idx];
                },
                set(obj, prop, value) {
                    const result = Reflect.set(...arguments);
                    this.order = Object.keys(obj).sort((a, b) => b - a);
                    let [x1, x2] = value.period, dt = this.dt;
                    if (this.dt.date() < parseInt(x2) || x2 === 0) {
                        dt = this.dt.subtract(1, "month");
                    }
                    let year = dt.year();
                    let month = dt.month() + 1;
                    x2 = x2 === 0 ? dt.daysInMonth() : x2;
                    month = (month + '').padStart(2, "0");

                    value.period = [
                        `${year}-${month}-${x1}`,
                        `${year}-${month}-${x2}`
                    ];
                    return result;
                }
            };
        }
        get(day = null) {
            const it = day ? this.table[day] : this.table[this.dt.date()];
            return it?.period;
        }
        next() {
            let dt = this.dt;
            const order = this.handler.order;
            const idx = (
                order.indexOf(this.get().dt.date() + '') - 1 + order.length  // 向上
            ) % order.length;
            if (idx == order.length - 1) {
                dt = dt.add(1, "month");
            }
            let year = dt.year();
            let month = dt.month();
            dt = this.table[order[idx]].dt
                .set("year", year)
                .set("month", month);
            return new Plan(dt, this.params);
        }
        _addParam(execTime, period) {
            // MM-dd HH:mm:ss
            const dt = dayjs.tz(new Date(), CST)
                .set("date", +execTime.substring(0, 2))
                .set("hour", +execTime.substring(3, 5));
            this.table[dt.date()] = { period, dt };
            this.params.push(arguments);
        }
    }
    const makeLogEntry = (message) => {
        return {
            time: dayjs.tz(new Date(), CST).format("HH:mm:ss"),
            message
        }
    };
    const addLog = (message, push) => chrome.runtime.sendMessage({ type: "addLog", data: makeLogEntry(message), push });

    const checkTime = (time) => {
        if (!time.isValid()) throw new Error("无效时间");
    };
    function getTimeDiff(dt, offset = 0) {
        const time = dayjs
            .tz(dt ?? new Date(), PT)
            .add(offset, "day");
        checkTime(time);
        return (dayjs().valueOf() - time.valueOf()) / 1000 / 60 / 60;  // h
    }

    function showModal() {
        document.querySelector('.modal').style.display = 'flex';
    }
    function renderLogs(logs) {
        const container = document.getElementById('logContainer');
        container.innerHTML = logs
            .map(log => `<div class="log-item">[${log.time}] ${log.message}</div>`)
            .join('');
        container.scrollTop = container.scrollHeight;
    }
    function onclick(e) {
        e.preventDefault();
        showModal();
        const btn = e.currentTarget;
        disableButton(btn);

        const boxes = document.querySelectorAll("input[name='option']:checked");
        boxes.forEach((box) => {
            const { name, uri, params } = TABLE[box.value.toUpperCase()];
            // const row = box.closest(".form-row");
            // const fromInput = row.querySelector("input[name='fromDate']");
            // const toInput = row.querySelector("input[name='toDate']");
            // const period = [fromInput.value, toInput.value];

            // const period = ['2025-01-01', '2025-02-01'];
            const period = new Plan(null, params).get();
            if (period === undefined) {
                addLog(`${name} 未到指定时间`, true);
                return;
            }
            // Deprecated
            const diff = getTimeDiff(period[1], 1);
            if (-12 < diff && diff < 0) {
                const select = confirm("时间未到, 是否确认继续");
                if (!select) return;
            }
            chrome.storage.local.get(['isRunning'], ({ isRunning }) => {
                if (!isRunning) {
                    chrome.runtime.sendMessage({ type: "run", data: { period, uri } });
                }
            });
        });
    }
    const enableButton = (btn) => {
        btn.disabled = false;
        btn.style.backgroundColor = "#007bff";
        btn.style.cursor = "pointer";
    };
    const disableButton = (btn) => {
        btn.disabled = true;
        btn.style.backgroundColor = "gray";
        btn.style.cursor = "default";
    };
    window.onload = function () {
        document.querySelector('.close').addEventListener('click', () => {
            document.querySelector('.modal').style.display = 'none';
        });
        const btn = document.querySelector(".confirm");
        chrome.storage.local.get(['isRunning', 'logs'], ({ isRunning = false, logs = [] }) => {
            if (isRunning) {
                disableButton(btn);
            } else {
                enableButton(btn);
            }
            showModal();
            renderLogs(logs);
        });
        document.querySelector('.cancel').addEventListener('click', () => {
            chrome.storage.local.set({ isRunning: false, logs: [] });
            chrome.runtime.sendMessage({ type: "resetTaskNum" });
            enableButton(btn);
        });
        chrome.runtime.onMessage.addListener((msg) => {
            if (msg.type === 'progress') {
                renderLogs(msg.logs);
            }
        });
        btn.addEventListener("click", onclick);
    };

})();
