import globals from "globals";
import pluginJs from "@eslint/js";


/** @type {import('eslint').Linter.Config[]} */
export default [
  {
    languageOptions: { globals: { ...globals.browser, ...globals.node, chrome: "readonly" } },
    rules: {
      "no-unused-vars": [
        "error",
        {
          argsIgnorePattern: "^_",     // 忽略函数参数
          varsIgnorePattern: "^_",     // 忽略普通变量
          destructuredArrayIgnorePattern: "^_", // 忽略解构数组中的变量
          caughtErrorsIgnorePattern: "^_" // 忽略 catch 错误变量
        }
      ]
    }
  },
  pluginJs.configs.recommended,
];