import { getValue } from "./util.js";

export const rrHeaders = () => {
    const rr = {
        "accept": "application/json",
        "content-type": "application/json",
        "wm_aurora.locale": "en-US",
        "wm_aurora.market": "US",
        "wm_aurora.timezone": "-08:00",
        "wm_aurora.tmxevent": "LOGIN",
        "wm_svc.name": "API",
        "x-xsrf-token": getValue("XSRF-TOKEN")
    };
    rr["wm_aurora.tmxid"] = JSON.parse(window.localStorage.getItem("TMX_DATA")).LOGIN.tmxId;
    rr["WM_QOS.CORRELATION_ID"] = ([1e7] + -1e3 + -4e3 + -8e3 + -1e11).replace(/[018]/g, (function (e) {
        return (e ^ crypto.getRandomValues(new Uint8Array(1))[0] & 15 >> e / 4).toString(16);
    }));
    return rr;
}
export const headers = Object.freeze({
    "wm_aurora.market": "US",
});
