from DrissionPage import Chromium
from DrissionPage.items import MixTab

from .browser import SuperBrowserBridge
from .const import USER_INFO, logger

class WFSExport:
    def __init__(self, start_date: str, end_date: str):
        self._start_date = start_date
        self._end_date = end_date
        self.bridge = SuperBrowserBridge(USER_INFO)
        self.bridge.init()
        self.cookies: dict = None
        self.uri: str = None

    def download_report(self, names: dict, params: dict, ext: str = 'csv'):
        pass

    def download_reports(self, tab: MixTab, driver: Chromium):
        """下载报表"""
        self.uri = "https://seller.walmart.com/aurora/v1/wfs/reports"
        tab.run_js()
        self.download_report({
            "apiName": "salesReport",
            "showName": "Orders"
            }, {
            "fromDate": self._start_date,
            "toDate": self._end_date,
        }, 'xlsx')
        self.download_report({
            "apiName": "salesReport",
            "showName": "Orders",
            "sheetName": "Multchannel_Fulfillment_Details"
            }, {
            "fromDate": self._start_date,
            "toDate": self._end_date,
            "type": "MCS"
        }, 'xlsx')
        self.download_report({
            "apiName": "returnsReport",
            "showName": "Customer returns"
            }, {
            "fromDate": f"{self._start_date}T00:00:00",
            "toDate": f"{self._end_date}T23:59:59",
        })

        self.download_report({
            "apiName": "poAudit",
            "showName": "Inbound receipts"
            }, {
            "fromDate": self._start_date,
            "toDate": self._end_date,
            "gtin": ""
        })
        self.download_report({
            "apiName": "inventoryReconciliation",
            "showName": "Inventory reconciliation"
            }, {
            "fromDate": self._start_date,
            "toDate": self._end_date,
        })
        breakpoint()
        # self.download_report({
        #     "apiName": "inventoryHealthReport",
        #     "showName": "Inventory health"
        #     }, None)

        self.download_report({
            "apiName": "feeDetailReport",
            "showName": "Settlement"
            }, {
            "startDate": self._start_date,
            "endDate": self._end_date,
        })
        self.download_report({
            "apiName": "storageFeeReport",
            "showName": "Storage"
            }, {
            "startDate": self._start_date,
            "endDate": self._end_date,
        })

    def download_payments(self, tab: MixTab, driver: Chromium):
        breakpoint()


    def pass_test(self, tab: MixTab, driver: Chromium):
        """人机检测"""
        breakpoint()
        logger.info("尝试通过人机检测")
        # tab.actions.move_to("#px-captcha").hold().release()
        tab.ele("@text()=登录").click()

        tab.wait.ele_displayed('@text()=WFS')
        cookies = tab.cookies()
        logger.debug(f"获取到cookies: {cookies.as_str()}")
        self.cookies = cookies.as_dict()

    def run(self):
        try:
            self.bridge.browser_list = [
                browser for browser in self.bridge.browser_list
                if browser['platform_name'] == '沃尔玛-全球'
            ]
            self.bridge.add_opt(self.pass_test)
            self.bridge.add_opt(self.download_reports)
            self.bridge.add_opt(self.download_payments)
            self.bridge.run(sn=1)
        finally:
            self.bridge.exit()
 