import logging
import sys
from datetime import datetime
from pathlib import Path

def create_logger(name: str):
    today = datetime.now().strftime("%Y-%m-%d")
    logger = logging.getLogger(name)
    logger.setLevel(logging.INFO)
    path = Path(__file__).parent.parent / 'log' / f"{today}_{name}.log"
    fhdlr = logging.FileHandler(path, encoding='utf8')
    shdlr = logging.StreamHandler(sys.stdout)
    fmt = logging.Formatter('%(asctime)s | %(levelname)s | %(module)s:%(funcName)s:%(lineno)d - %(message)s')
    fhdlr.setFormatter(fmt)
    shdlr.setFormatter(fmt)
    logger.addHandler(fhdlr)
    logger.addHandler(shdlr)
    return logger
